#include<stdio.h>
#include<stdlib.h>
#include<unistd.h>
#include<pthread.h>

#define BROJ_VOZILA 10
#define BROJ_SMER_A 5
#define BROJ_SMER_B 5

pthread_mutex_t mutex_nadvoznjak;
pthread_cond_t cond_nadvoznjak;

/* 
    smer = 0 -> nema vozila na nadvoznjaku
    smer = 1 -> vozila idu iz smera A
    smer = 2 -> vozila idu iz smera B
*/

/* 
    tip_vozila = 0 -> automobil
    tip_vozila = 1 -> autobus
    tip_vozila = 2 -> kamion
*/

int smer = 0;

/*
    broj_vozila_na_nadvoznjaku[0] -> automobili
    broj_vozila_na_nadvoznjaku[1] -> autobusi
    broj_vozila_na_nadvoznjaku[2] -> kamioni

*/
int broj_vozila_na_nadvoznjaku[3] = {0, 0, 0};

void *work_smer_a(void *arg){
    
    int tip_vozila = rand() % 3;
    long id = (long) arg;

    if(tip_vozila == 0){ //automobil
        sleep(rand()%5);
        printf("Automobil sa id-jem %ld ide iz smera A i zeli da predje preko nadvoznjaka.\n", id);
        
        pthread_mutex_lock(&mutex_nadvoznjak);
        while(smer == 2 || (smer == 1 && broj_vozila_na_nadvoznjaku[2] == 1)){
            pthread_cond_wait(&cond_nadvoznjak, &mutex_nadvoznjak);
        }

        smer = 1;
        broj_vozila_na_nadvoznjaku[0]++;
        pthread_mutex_unlock(&mutex_nadvoznjak);

        printf("Automobil sa id-jem %ld ide iz smera A i prelazi preko nadvoznjaka.\n", id);
        sleep(1);
        
        pthread_mutex_lock(&mutex_nadvoznjak);
        broj_vozila_na_nadvoznjaku[0]--;
        if(broj_vozila_na_nadvoznjaku[0] + broj_vozila_na_nadvoznjaku[1] + broj_vozila_na_nadvoznjaku[2] == 0){
            smer = 0;
        }
        pthread_cond_broadcast(&cond_nadvoznjak);
        pthread_mutex_unlock(&mutex_nadvoznjak);
    }
    if(tip_vozila == 1){ //autobus
        sleep(rand()%5);
        printf("Autobus sa id-jem %ld ide iz smera A i zeli da predje preko nadvoznjaka.\n", id);
        
        pthread_mutex_lock(&mutex_nadvoznjak);

        while(smer == 2 || (smer == 1 && (broj_vozila_na_nadvoznjaku[2] == 1 || broj_vozila_na_nadvoznjaku[1] == 1))){
            pthread_cond_wait(&cond_nadvoznjak, &mutex_nadvoznjak);
        }

        smer = 1;
        broj_vozila_na_nadvoznjaku[1] = 1;
        pthread_mutex_unlock(&mutex_nadvoznjak);

        printf("Autobus sa id-jem %ld ide iz smera A i prelazi preko nadvoznjaka.\n", id);
        sleep(1);

        pthread_mutex_lock(&mutex_nadvoznjak);
        broj_vozila_na_nadvoznjaku[1] = 0;
        if(broj_vozila_na_nadvoznjaku[0] + broj_vozila_na_nadvoznjaku[1] + broj_vozila_na_nadvoznjaku[2] == 0){
            smer = 0;
        }
        pthread_cond_broadcast(&cond_nadvoznjak);
        pthread_mutex_unlock(&mutex_nadvoznjak);
    }
    if(tip_vozila == 2){ //kamion
        sleep(rand()%5);
        printf("Kamion sa id-jem %ld ide iz smera A i zeli da predje preko nadvoznjaka.\n", id);
        
        pthread_mutex_lock(&mutex_nadvoznjak);

        while(smer == 2 || (smer ==  1 && (broj_vozila_na_nadvoznjaku[2] == 1 || 
        broj_vozila_na_nadvoznjaku[0] + broj_vozila_na_nadvoznjaku[1] > 0))){
            pthread_cond_wait(&cond_nadvoznjak, &mutex_nadvoznjak);
        }

        smer = 1;
        broj_vozila_na_nadvoznjaku[2] = 1;
        pthread_mutex_unlock(&mutex_nadvoznjak);

        printf("Kamion sa id-jem %ld ide iz smera A i prelazi preko nadvoznjaka.\n", id);
        sleep(1);

        pthread_mutex_lock(&mutex_nadvoznjak);
        broj_vozila_na_nadvoznjaku[2] = 0;
        if(broj_vozila_na_nadvoznjaku[0] + broj_vozila_na_nadvoznjaku[1] + broj_vozila_na_nadvoznjaku[2] == 0){
            smer = 0;
        }
        pthread_cond_broadcast(&cond_nadvoznjak);
        pthread_mutex_unlock(&mutex_nadvoznjak);
    }
    return NULL;
}

void *work_smer_b(void *arg){
    
    int tip_vozila = rand() % 3;
    long id = (long) arg;

    if(tip_vozila == 0){ //automobil
        sleep(rand()%5);
        printf("Automobil sa id-jem %ld ide iz smera B i zeli da predje preko nadvoznjaka.\n", id);
        
        
        pthread_mutex_lock(&mutex_nadvoznjak);
        while(smer == 1 || (smer == 2 && broj_vozila_na_nadvoznjaku[2] == 1)){
            pthread_cond_wait(&cond_nadvoznjak, &mutex_nadvoznjak);
        }

        smer = 2;
        broj_vozila_na_nadvoznjaku[0]++;
        pthread_mutex_unlock(&mutex_nadvoznjak);

        printf("Automobil sa id-jem %ld ide iz smera B i prelazi preko nadvoznjaka.\n", id);
        sleep(1);
        
        pthread_mutex_lock(&mutex_nadvoznjak);
        broj_vozila_na_nadvoznjaku[0]--;
        if(broj_vozila_na_nadvoznjaku[0] + broj_vozila_na_nadvoznjaku[1] + broj_vozila_na_nadvoznjaku[2] == 0){
            smer = 0;
        }
        pthread_cond_broadcast(&cond_nadvoznjak);
        pthread_mutex_unlock(&mutex_nadvoznjak);
    }
    if(tip_vozila == 1){ //autobus
        sleep(rand()%5);
        printf("Autobus sa id-jem %ld ide iz smera B i zeli da predje preko nadvoznjaka.\n", id);
        
        pthread_mutex_lock(&mutex_nadvoznjak);

        while(smer == 1 || (smer == 2 && (broj_vozila_na_nadvoznjaku[2] == 1 || broj_vozila_na_nadvoznjaku[1] == 1))){
            pthread_cond_wait(&cond_nadvoznjak, &mutex_nadvoznjak);
        }

        smer = 2;
        broj_vozila_na_nadvoznjaku[1] = 1;
        pthread_mutex_unlock(&mutex_nadvoznjak);

        printf("Autobus sa id-jem %ld ide iz smera B i prelazi preko nadvoznjaka.\n", id);
        sleep(1);

        pthread_mutex_lock(&mutex_nadvoznjak);
        broj_vozila_na_nadvoznjaku[1] = 0;
        if(broj_vozila_na_nadvoznjaku[0] + broj_vozila_na_nadvoznjaku[1] + broj_vozila_na_nadvoznjaku[2] == 0){
            smer = 0;
        }
        pthread_cond_broadcast(&cond_nadvoznjak);
        pthread_mutex_unlock(&mutex_nadvoznjak);
    }
    if(tip_vozila == 2){ //kamion
        sleep(rand()%5);
        printf("Kamion sa id-jem %ld ide iz smera B i zeli da predje preko nadvoznjaka.\n", id);
        
        pthread_mutex_lock(&mutex_nadvoznjak);

        while(smer == 1 || (smer == 2 && (broj_vozila_na_nadvoznjaku[2] == 1 || 
        broj_vozila_na_nadvoznjaku[1] + broj_vozila_na_nadvoznjaku[0] > 0))){
            pthread_cond_wait(&cond_nadvoznjak, &mutex_nadvoznjak);
        }

        smer = 2;
        broj_vozila_na_nadvoznjaku[2] = 1;
        pthread_mutex_unlock(&mutex_nadvoznjak);

        printf("Kamion sa id-jem %ld ide iz smera B i prelazi preko nadvoznjaka.\n", id); 
        sleep(1);

        pthread_mutex_lock(&mutex_nadvoznjak);
        broj_vozila_na_nadvoznjaku[2] = 0;
        if(broj_vozila_na_nadvoznjaku[0] + broj_vozila_na_nadvoznjaku[1] + broj_vozila_na_nadvoznjaku[2] == 0){
            smer = 0;
        }
        pthread_cond_broadcast(&cond_nadvoznjak);
        pthread_mutex_unlock(&mutex_nadvoznjak);
    }
    return NULL;
}


int main(){

    pthread_t vozila[BROJ_VOZILA];
    srand(rand());

    pthread_mutex_init(&mutex_nadvoznjak, NULL);
    pthread_cond_init(&cond_nadvoznjak, NULL);

    for(long i = 0; i < BROJ_SMER_A; i++){
        pthread_create(&vozila[i], NULL, work_smer_a, (void*)i);
    }

    for(long i = 0; i < BROJ_SMER_B; i++){
        pthread_create(&vozila[i + BROJ_SMER_A], NULL, work_smer_b, (void*)i + BROJ_SMER_A);    
    }

    for(int i = 0; i < BROJ_SMER_A + BROJ_SMER_B; i++){
        pthread_join(vozila[i], NULL);
    }

    return 0;
}